/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.ai;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.objects.te.TENestBox;
import net.dries007.tfc.util.Helpers;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIFindNest
extends EntityAIBase {
    private final double speed;
    private final EntityAnimal theCreature;
    private final World theWorld;
    private final Map<BlockPos, Long> failureDepressionMap;
    private int currentTick;
    private int maxSittingTicks;
    private boolean end;
    private BlockPos nestPos = null;

    public EntityAIFindNest(EntityAnimal eAnimal, double speed) {
        this.theCreature = eAnimal;
        this.speed = speed;
        this.theWorld = eAnimal.field_70170_p;
        this.failureDepressionMap = new HashMap<BlockPos, Long>();
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.theCreature instanceof IAnimalTFC && ((IAnimalTFC)this.theCreature).getType() == IAnimalTFC.Type.OVIPAROUS) {
            IAnimalTFC animal = (IAnimalTFC)this.theCreature;
            return animal.isReadyForAnimalProduct() && this.getNearbyNest();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.end || !this.isNestBlock(this.theWorld, this.nestPos)) {
            this.end = false;
            this.theCreature.func_70661_as().func_75499_g();
            if (this.theCreature.func_184218_aH()) {
                this.theCreature.func_184210_p();
            }
            return false;
        }
        return true;
    }

    public void func_75249_e() {
        this.theCreature.func_70661_as().func_75492_a((double)this.nestPos.func_177958_n() + 0.5, (double)(this.nestPos.func_177956_o() + 1), (double)this.nestPos.func_177952_p() + 0.5, this.speed);
        this.currentTick = 0;
        this.end = false;
        this.maxSittingTicks = this.theCreature.func_70681_au().nextInt(200) + 100;
    }

    public void func_75246_d() {
        ++this.currentTick;
        if (this.nestPos == null) {
            return;
        }
        if (this.theCreature.func_174818_b(this.nestPos) > 1.25) {
            this.theCreature.func_70661_as().func_75492_a((double)this.nestPos.func_177958_n() + 0.5, (double)this.nestPos.func_177956_o(), (double)this.nestPos.func_177952_p() + 0.5, this.speed);
            if (this.currentTick > 200) {
                this.failureDepressionMap.put(this.nestPos, this.theWorld.func_82737_E() + 4000L);
                this.end = true;
            }
        } else {
            TENestBox te = Helpers.getTE((IBlockAccess)this.theWorld, this.nestPos, TENestBox.class);
            if (te != null && this.theCreature instanceof IAnimalTFC && ((IAnimalTFC)this.theCreature).getType() == IAnimalTFC.Type.OVIPAROUS) {
                IAnimalTFC animal = (IAnimalTFC)this.theCreature;
                if (!te.hasBird()) {
                    te.seatOnThis((EntityLiving)this.theCreature);
                    this.currentTick = 0;
                }
                if (this.currentTick >= this.maxSittingTicks) {
                    List<ItemStack> eggs = animal.getProducts();
                    for (ItemStack egg : eggs) {
                        te.insertEgg(egg);
                    }
                    animal.setFertilized(false);
                    animal.setProductsCooldown();
                    this.end = true;
                } else if (te.getBird() != this.theCreature) {
                    this.failureDepressionMap.put(this.nestPos, this.theWorld.func_82737_E() + 4000L);
                    this.end = true;
                }
            }
        }
    }

    private boolean getNearbyNest() {
        int i = (int)this.theCreature.field_70163_u;
        double d0 = Double.MAX_VALUE;
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.theCreature.func_180425_c().func_177982_a(-16, 0, -16), (BlockPos)this.theCreature.func_180425_c().func_177982_a(16, 4, 16))) {
            double d1;
            if (!this.isNestBlock(this.theWorld, (BlockPos)pos) || !this.theWorld.func_175623_d(pos.func_177984_a()) || !((d1 = this.theCreature.func_174818_b((BlockPos)pos)) < d0)) continue;
            this.nestPos = pos.func_185334_h();
            d0 = d1;
        }
        return d0 < Double.MAX_VALUE;
    }

    private boolean isNestBlock(World world, BlockPos pos) {
        TENestBox te;
        if (world == null || pos == null) {
            return false;
        }
        if (this.failureDepressionMap.containsKey(pos)) {
            long time = this.failureDepressionMap.get(pos);
            if (time > world.func_82737_E()) {
                return false;
            }
            this.failureDepressionMap.remove(pos);
        }
        return (te = Helpers.getTE((IBlockAccess)world, pos, TENestBox.class)) != null && te.hasFreeSlot() && (!te.hasBird() || te.getBird() == this.theCreature);
    }
}

